from functools import wraps
from django.utils import timezone
from django.shortcuts import get_object_or_404, redirect
from django.contrib.auth.decorators import user_passes_test
from django.http import HttpResponseForbidden, HttpResponseServerError



# from .models import *

def has_manager_permissions(user):
    return user.is_authenticated and (user.is_superuser or user.is_staff or user.groups.filter(name='managers').exists())

def user_authenticated(view_func):
    def _wrapped_view(request, *args, **kwargs):
        if request.user.is_authenticated and request.user.is_active:
            return view_func(request, *args, **kwargs)
        return redirect('auth_signin')  

    return _wrapped_view

def is_partner(view_func):
    @wraps(view_func)
    def _wrapped_view(request, *args, **kwargs):
        if request.user.is_authenticated and hasattr(request.user, 'userprofile') and request.user.userprofile.is_partner:
            return view_func(request, *args, **kwargs)
        return redirect('Dashboard')
    return _wrapped_view

def is_nurse(view_func):
    @wraps(view_func)
    def _wrapped_view(request, *args, **kwargs):
        if request.user.is_authenticated and hasattr(request.user, 'userprofile') and request.user.userprofile.is_nurse:
            return view_func(request, *args, **kwargs)
        return redirect('Dashboard')
    return _wrapped_view

def is_doctor(view_func):
    @wraps(view_func)
    def _wrapped_view(request, *args, **kwargs):
        if request.user.is_authenticated and hasattr(request.user, 'userprofile') and request.user.userprofile.is_doctor:
            return view_func(request, *args, **kwargs)
        return redirect('Dashboard')
    return _wrapped_view

def is_pharmacist(view_func):
    @wraps(view_func)
    def _wrapped_view(request, *args, **kwargs):
        if request.user.is_authenticated and hasattr(request.user, 'userprofile') and request.user.userprofile.is_pharmacist:
            return view_func(request, *args, **kwargs)
        return redirect('Dashboard')
    return _wrapped_view

def is_moderator(view_func):
    @wraps(view_func)
    def _wrapped_view(request, *args, **kwargs):
        if request.user.is_authenticated and hasattr(request.user, 'userprofile') and request.user.userprofile.is_moderator:
            return view_func(request, *args, **kwargs)
        return redirect('Dashboard')
    return _wrapped_view

def is_partner(view_func):
    @wraps(view_func)
    def _wrapped_view(request, *args, **kwargs):
        if request.user.is_authenticated and hasattr(request.user, 'userprofile') and request.user.userprofile.is_partner:
            return view_func(request, *args, **kwargs)
        return redirect('Dashboard') 
    return _wrapped_view

def block_all_roles(view_func):
    @wraps(view_func)
    def _wrapped_view(request, *args, **kwargs):
        # Check if user is authenticated and has a UserProfile
        if request.user.is_authenticated and hasattr(request.user, 'userprofile'):
            user_profile = request.user.userprofile
            # Check if any role attribute is set to True
            if (user_profile.is_nurse or user_profile.is_doctor or
                user_profile.is_pharmacist or user_profile.is_partner or
                user_profile.is_moderator):
                return redirect('Dashboard')
        return view_func(request, *args, **kwargs)
    
    return _wrapped_view