from django import forms
from .models.ProgressReport import ProgressReport


class ProgressReportForm(forms.ModelForm):
    class Meta:
        model = ProgressReport
        fields = ['title', 'description', 'user_assignee', 'progress_report_priority', 'progress_report_tags', 'donor', 'organization', 'post', 'program', 'project', 'grant_Application', 'grant_opportunity', 'progress_report_document', 'cash_received', 'asset', 'liability', 'expenses_paid', 'reserve', 'anticipated_revenue']
        widgets = {
            'description': forms.Textarea(attrs={'required': False}),
            'user_assignee': forms.Select(attrs={'required': False}),
        }