from django.db import models
from django.utils.text import slugify
from django.contrib.auth.models import User


class ActivityLog(models.Model):
    user = models.ForeignKey(User, on_delete=models.CASCADE, null=True, blank=True, help_text="The Activity Log record to a specific user in the system." )
    action = models.CharField( max_length=255, help_text="Action performed, representing the activity. Example: 'Login'" )
    timestamp = models.DateTimeField( auto_now_add=True, help_text="Timestamp of when the activity occurred. Example: '2024-01-15 12:30:45'" )
    details = models.TextField( blank=True, null=True, help_text="Additional details about the activity. (Optional) Example: 'Successful login from IP: 192.168.0.1'" )
    ip_address = models.GenericIPAddressField( blank=True, null=True, help_text="IP address associated with the activity. (Optional) Example: '192.168.0.1'" )
    user_agent = models.CharField( max_length=255, blank=True, null=True, help_text="User agent information associated with the activity. (Optional) Example: 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.110 Safari/537.36'" )
    status_code = models.IntegerField( blank=True, null=True, help_text="HTTP status code associated with the activity. (Optional) Example: '200' for a successful request." )
    
    def __str__(self):
        if self.user:
            return f"{self.user.first_name} - {self.action} on {self.timestamp}"
        else:
            return f"Anonymous - {self.action} on {self.timestamp}"