from django.db import models

class ContactAdminMessages(models.Model):
    name = models.CharField(max_length=50)
    email = models.EmailField(max_length=50)
    phone = models.CharField(max_length=50)
    message = models.CharField(max_length=255)
    request_date = models.DateField(auto_now_add=True)
    seen = models.BooleanField(default=False)
    seen_date = models.DateField(null=True, blank=True)

    class Meta:
        verbose_name = 'Admin Contact Message'
        verbose_name_plural = 'Admin Contact Messages'

    def __str__(self):
        return f"{self.name} - {self.email} - {self.phone} - message to admin"
    
    
class ContactDeveloper(models.Model):
    user = models.ForeignKey('UserProfile', on_delete=models.CASCADE)
    subject = models.CharField(max_length=255)
    message = models.CharField(max_length=500)
    request_date = models.DateField(auto_now_add=True)
    seen = models.BooleanField(default=False)
    seen_date = models.DateField(null=True, blank=True)

    class Meta:
        verbose_name = 'Admin Contact Message'
        verbose_name_plural = 'Admin Contact Messages'

    def __str__(self):
        first_name = getattr(self.user.user, 'first_name', 'Unknown')
        return f"{first_name} -- {self.subject} -- Message to Developer"