from django.db import models
from django.utils.text import slugify
from django.utils import timezone

class OrganizationFile(models.Model):
    name = models.CharField(max_length=255, help_text="Name of the file")
    file = models.FileField(upload_to='organization_files/', help_text="File to be uploaded")
    created_at = models.DateTimeField(default=timezone.now, help_text="Date the file was uploaded")
    updated_at = models.DateTimeField(auto_now=True)
    slug = models.SlugField(unique=True, blank=True)

    class Meta:
        verbose_name = 'Najimudu Organization File'
        verbose_name_plural = 'Najimudu Organization Files'

    def save(self, *args, **kwargs):
        # Handle unique name with counter
        if not self.pk:  # Only check for duplicates on new objects
            base_name = self.name
            name = base_name
            counter = 1
            while OrganizationFile.objects.filter(name=name).exists():
                name = f"{base_name} ({counter})"
                counter += 1
            self.name = name

        # Handle unique slug with counter
        if not self.slug:
            base_slug = slugify(self.name)
            slug = base_slug
            counter = 1
            while OrganizationFile.objects.filter(slug=slug).exists():
                slug = f"{base_slug}-{counter}"
                counter += 1
            self.slug = slug

        super().save(*args, **kwargs)

    def __str__(self):
        return self.name
