from django.contrib import admin
from django.urls import path, include
from django.conf.urls.static import static
from vristo import settings

urlpatterns = [
    path('admin/', admin.site.urls),
    path("", include("main.urls")),
    path('accounts/', include('allauth.urls')),
    path("ckeditor5/", include('django_ckeditor_5.urls'), name="ck_editor_5_upload_file"),
]
# Serving media files
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
# Serving static files
urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)